---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：46-kubeadm join

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **各フェーズの具体的な実装内容**：phases/join/ディレクトリは未読

## 2) 参照した情報（Evidence一覧）

- E-01: `cmd/kubeadm/app/cmd/join.go` - joinコマンド本体
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 8つのフェーズが登録される | E-01 行222-229 | ○ |
| C-02 | ワーカーとCP参加で異なるメッセージを表示 | E-01 行57-83, 192-211 | ○ |
| C-03 | --tokenはdiscovery-tokenとtls-bootstrap-tokenの両方に使用 | E-01 行363-370 | ○ |
| C-04 | ディスカバリ方式はトークンとファイルの2種類 | E-01 行85-128 joinLongDescription | ○ |
| C-05 | --control-plane未指定時にControlPlaneをnil化 | E-01 行388-406 | ○ |
| C-06 | admin.conf存在時にディスカバリをスキップ | E-01 行411-418 | ○ |
| C-07 | 最大1つの位置引数を受け付ける | E-01 行217 cobra.MaximumNArgs(1) | ○ |
| C-08 | 複数引数指定時に警告を表示 | E-01 行382-383 | ○ |
| C-09 | DryRunモードで一時ディレクトリ使用 | E-01 行469-474 | ○ |
| C-10 | --skip-phasesでフェーズをスキップ可能 | E-01 行244-246 | ○ |
| C-11 | 関連機能119-ノード参加が主機能 | E-03 画面No46 | ○ |
| C-12 | 関連機能121-証明書管理が補助機能 | E-03 画面No46 | ○ |
| C-13 | fetchInitConfigurationFromJoinConfigurationで設定取得 | E-01 行678-724 | ○ |
| C-14 | joinOptions構造体の定義 | E-01 行134-143 | ○ |
| C-15 | joinData構造体の定義 | E-01 行150-160 | ○ |
| C-16 | 各フェーズの具体的な処理内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- phases/join/ディレクトリ内の各フェーズ実装は未読
  - 候補：phases/join/preflight.go / controlplaneprepare.go / kubeletstart.go 等

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ディスカバリとTLSブートストラップの詳細フローはjoin.goのみからは完全に把握できない

## 6) レビュアーチェックリスト（最小）
- [ ] phases/join/ディレクトリの各フェーズ実装を確認
- [ ] ディスカバリ処理（discovery/パッケージ）の詳細を確認
- [ ] コントロールプレーン参加時のetcd参加処理を確認
